package com.taiwanmobile.pt.tamedia.tutorial.compose

import android.app.Activity
import android.graphics.Color
import android.os.Bundle
import android.widget.Toast
import androidx.activity.ComponentActivity
import androidx.activity.SystemBarStyle
import androidx.activity.compose.setContent
import androidx.activity.enableEdgeToEdge
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.WindowInsets
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.navigationBars
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.windowInsetsBottomHeight
import androidx.compose.material3.Button
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBar
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.taiwanmobile.pt.adp.view.TWMAd
import com.taiwanmobile.pt.adp.view.TWMAdRequest
import com.taiwanmobile.pt.adp.view.TWMAdViewListener
import com.taiwanmobile.pt.adp.view.TWMInterstitialAd

const val interstitialAdUnitId = "YOUR_INTERSTITIAL_AD_UNIT_ID"

class InterstitialComposeActivity : ComponentActivity() {

    private lateinit var interstitialAd: TWMInterstitialAd
    private var adReceived by mutableStateOf(false)
    private var isShowAdButtonVisible by mutableStateOf(false)

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge(
            statusBarStyle = SystemBarStyle.light(
                Color.TRANSPARENT, Color.TRANSPARENT
            )
        )

        setContent {
            HomeScreen(
                adReceived = adReceived,
                adUnitId = interstitialAdUnitId,
                onShowAd = {
                    interstitialAd.show()
                    isShowAdButtonVisible = false
                },
                isShowAdButtonVisible = isShowAdButtonVisible
            )
        }

        initAd(this, interstitialAdUnitId)
    }

    /**
     * Initialize TWMInterstitialAd by activity & adUnitId.
     *
     * @param activity [Activity]
     * @param adUnitId [String]
     */
    @Suppress("SameParameterValue")
    private fun initAd(activity: Activity, adUnitId: String) {
        interstitialAd = TWMInterstitialAd(activity, adUnitId)
        interstitialAd.setAdListener(object : TWMAdViewListener {
            override fun onReceiveAd(ad: TWMAd) {
                adReceived = true
                isShowAdButtonVisible = true
            }

            override fun onFailedToReceiveAd(
                ad: TWMAd,
                errorCode: TWMAdRequest.ErrorCode
            ) {
                Toast.makeText(this@InterstitialComposeActivity, errorCode.name, Toast.LENGTH_SHORT)
                    .show()
            }

            override fun onPresentScreen(ad: TWMAd) {}
            override fun onDismissScreen(ad: TWMAd) {}
            override fun onLeaveApplication(ad: TWMAd) {}

        })
        // Request interstitial from TAMedia.
        interstitialAd.loadAd(TWMAdRequest())
    }

    override fun onDestroy() {
        super.onDestroy()
        interstitialAd.destroy()
    }
}

@Suppress("SameParameterValue")
@OptIn(ExperimentalMaterial3Api::class)
@Composable
private fun HomeScreen(
    adReceived: Boolean,
    adUnitId: String,
    onShowAd: () -> Unit,
    isShowAdButtonVisible: Boolean
) {
    Scaffold(
        topBar = {
            TopAppBar(
                title = { Text("Interstitial Example") }
            )
        },
        bottomBar = {
            Box(
                modifier = Modifier
                    .fillMaxWidth()
                    .windowInsetsBottomHeight(WindowInsets.navigationBars)
                    .background(MaterialTheme.colorScheme.primaryContainer)
            )
        }
    ) { innerPadding ->

        Column(
            modifier = Modifier
                .fillMaxSize()
                .padding(innerPadding)
                .padding(horizontal = 16.dp),
            verticalArrangement = Arrangement.Top,
            horizontalAlignment = Alignment.Start
        ) {
            if (adReceived) {
                Text("AdUnitId: $adUnitId")

                Spacer(modifier = Modifier.height(16.dp))

                // Hide the button after showing the ad.
                if (isShowAdButtonVisible) {
                    Box(
                        modifier = Modifier.fillMaxWidth(),
                        contentAlignment = Alignment.TopStart
                    ) {
                        Button(onClick = onShowAd) {
                            Text("Show Ad")
                        }
                    }
                }
            }
        }
    }
}
