package com.taiwanmobile.pt.tamedia.tutorial.compose

import android.app.Activity
import android.graphics.Color
import android.os.Bundle
import android.widget.Toast
import androidx.activity.ComponentActivity
import androidx.activity.SystemBarStyle
import androidx.activity.compose.setContent
import androidx.activity.enableEdgeToEdge
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.WindowInsets
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.navigationBars
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.windowInsetsBottomHeight
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBar
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.taiwanmobile.pt.adp.view.TWMAd
import com.taiwanmobile.pt.adp.view.TWMAdRequest
import com.taiwanmobile.pt.adp.view.TWMAdViewListener
import com.taiwanmobile.pt.adp.view.inread.TWMInReadAdAnchor

const val inReadAdUnitId = "YOUR_INREAD_AD_UNIT_ID"

class InReadComposeActivity : ComponentActivity() {

    private lateinit var anchorView: TWMInReadAdAnchor
    private var adReceived by mutableStateOf(false)

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge(
            statusBarStyle = SystemBarStyle.light(
                Color.TRANSPARENT, Color.TRANSPARENT
            )
        )

        setContent {
            HomeScreen(adReceived = adReceived, inReadAdUnitId)
        }

        initAd(this, inReadAdUnitId)

    }

    override fun onResume() {
        super.onResume()
        anchorView.resume()
    }

    override fun onPause() {
        super.onPause()
        anchorView.pause()
    }

    override fun onDestroy() {
        super.onDestroy()
        anchorView.destroy()
    }

    /**
     * Initialize TWMInReadAnchor by activity & adUnitId.
     *
     * @param activity [Activity]
     * @param adUnitId [String]
     */
    @Suppress("SameParameterValue")
    private fun initAd(activity: Activity, adUnitId: String) {
        anchorView = TWMInReadAdAnchor(activity, inReadAdUnitId).apply {
            setAdListener(object : TWMAdViewListener {
                override fun onReceiveAd(ad: TWMAd) {
                    adReceived = true
                }

                override fun onFailedToReceiveAd(ad: TWMAd, errorCode: TWMAdRequest.ErrorCode) {
                    Toast.makeText(this@InReadComposeActivity, errorCode.name, Toast.LENGTH_SHORT)
                        .show()
                }

                override fun onPresentScreen(ad: TWMAd) {}
                override fun onDismissScreen(ad: TWMAd) {}
                override fun onLeaveApplication(ad: TWMAd) {}
            })
            loadAd(TWMAdRequest())
        }
    }
}

@Suppress("SameParameterValue")
@OptIn(ExperimentalMaterial3Api::class)
@Composable
private fun HomeScreen(adReceived: Boolean, adUnitId: String) {
    Scaffold(
        topBar = {
            TopAppBar(
                title = { Text("InRead Example") }
            )
        },
        bottomBar = {
            Box(
                modifier = Modifier
                    .fillMaxWidth()
                    .windowInsetsBottomHeight(WindowInsets.navigationBars)
                    .background(MaterialTheme.colorScheme.primaryContainer)
            )
        }
    ) { innerPadding ->

        Column(
            modifier = Modifier
                .fillMaxSize()
                .padding(innerPadding)
                .padding(horizontal = 16.dp),
            verticalArrangement = Arrangement.Top,
            horizontalAlignment = Alignment.Start
        ) {
            if (adReceived) {
                Text("AdUnitId: $adUnitId")
            }
        }
    }
}
