package com.taiwanmobile.pt.tamedia.tutorial;

import android.content.Intent;
import android.os.Bundle;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsControllerCompat;

import com.taiwanmobile.pt.adp.nativead.TWMMediaContent;
import com.taiwanmobile.pt.adp.nativead.TWMMediaView;
import com.taiwanmobile.pt.adp.nativead.TWMNativeAdContent;
import com.taiwanmobile.pt.adp.nativead.TWMNativeAdOptions;
import com.taiwanmobile.pt.adp.view.TWMAd;
import com.taiwanmobile.pt.adp.view.TWMAdRequest;
import com.taiwanmobile.pt.adp.view.TWMAdViewListener;
import com.taiwanmobile.pt.adp.view.TWMNativeAd;
import com.taiwanmobile.pt.adp.view.TWMNativeAdView;

import java.util.ArrayList;
import java.util.List;

public class NativeActivity extends AppCompatActivity {

    private TextView tvResult = null;
    private TextView tvLongTitle = null, tvShortTitle = null, tvContent = null;

    private ImageView ivIcon120x120 = null, ivIcon96x64 = null;
    private ImageView ivImage960x640 = null, ivImage1200x627 = null;

    private TextView tvCTA = null;

    private TWMMediaView mediaView = null;

    private TWMNativeAd nativeAd = null;
    private TWMNativeAdView mNativeAdView = null;

    private boolean mAdDisableImageLoading = false;
    private boolean mAdVideoStartUnmuted = false;
    private boolean mAdVideoCustomControlsRequested = false;
    private boolean mAdMediaPreferImage = false;
    private boolean mAdMediaPreferImageSizeBig = false;

    public final static String KEY_AD_DISABLE_IMAGE_LOADING = "ad_disable_image_loading";
    public final static String KEY_AD_VIDEO_START_UNMUTED = "ad_video_start_unmuted";
    public final static String KEY_AD_VIDEO_CUSTOM_CONTROLS_REQUESTED = "ad_video_custom_controls_requested";
    public final static String KEY_AD_MEDIA_PREFER_IMAGE  = "ad_media_prefer_image";
    public final static String KEY_AD_MEDIA_PREFER_IMAGE_SIZE_BIG  = "ad_media_prefer_image_size_big";

    public final String TAMEDIA_NATIVE_ADUNITID = "YOUR_NATIVE_AD_UNIT_ID";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // make the status bar icons visible (for light status bar backgrounds)
        WindowInsetsControllerCompat insetsController = WindowCompat.getInsetsController(getWindow(), getWindow().getDecorView());
        insetsController.setAppearanceLightStatusBars(true);

        setContentView(R.layout.activity_native);

        tvResult = findViewById(R.id.native_result);
        tvLongTitle = findViewById(R.id.native_long_title);
        tvShortTitle = findViewById(R.id.native_short_title);
        tvContent = findViewById(R.id.native_content);

        ivIcon120x120 = findViewById(R.id.native_image_120x120);
        ivIcon96x64 = findViewById(R.id.native_image_96x64);
        tvCTA = findViewById(R.id.native_native_cta);

        ivImage960x640 = findViewById(R.id.native_image_960_640);
        ivImage1200x627 = findViewById(R.id.native_image_1200_627);

        mediaView = findViewById(R.id.native_media_view);
        mNativeAdView = findViewById(R.id.nativeAdView);
        // get extra data from MainActivity
        Intent intent = getIntent();
        Bundle args = intent.getExtras();
        if (args != null) {
            mAdDisableImageLoading = args.getBoolean(KEY_AD_DISABLE_IMAGE_LOADING, false);
            mAdVideoStartUnmuted = args.getBoolean(KEY_AD_VIDEO_START_UNMUTED, false);
            mAdMediaPreferImage = args.getBoolean(KEY_AD_MEDIA_PREFER_IMAGE, false);
            mAdMediaPreferImageSizeBig = args.getBoolean(KEY_AD_MEDIA_PREFER_IMAGE_SIZE_BIG, false);
            mAdVideoCustomControlsRequested = args.getBoolean(KEY_AD_VIDEO_CUSTOM_CONTROLS_REQUESTED, false);
        }

        initAd();
    }

    @Override
    protected void onDestroy() {
        if (nativeAd != null) {
            nativeAd.destroy();
        }
        super.onDestroy();
    }

    private void initAd() {

        // Init native ad
        nativeAd = new TWMNativeAd(this, TAMEDIA_NATIVE_ADUNITID);

        // Set listener for native.
        nativeAd.setAdListener(adListener);

        // set options
        List<TWMNativeAdOptions> nativeOptions = new ArrayList<>();
        if (mAdDisableImageLoading) {
            nativeOptions.add(TWMNativeAdOptions.DISABLE_IMAGE_LOADING);
        }
        if (mAdVideoStartUnmuted) {
            nativeOptions.add(TWMNativeAdOptions.VIDEO_START_UNMUTED);
        }
        if (mAdVideoCustomControlsRequested) {
            nativeOptions.add(TWMNativeAdOptions.VIDEO_CUSTOM_CONTROLS_REQUESTED);
        }
        if (mAdMediaPreferImage) {
            nativeOptions.add(TWMNativeAdOptions.MEDIA_PREFER_IMAGE);
        }

        // Request native from TAMedia.
        nativeAd.loadAd(getAdRequest(nativeOptions));
    }

    private TWMAdRequest getAdRequest(List<TWMNativeAdOptions> nativeOptions) {
        TWMAdRequest adRequest = new TWMAdRequest();
        if (nativeOptions != null) {
            TWMNativeAdOptions[] nativeAdOptionsArray = new TWMNativeAdOptions[nativeOptions.size()];
            nativeAdOptionsArray = nativeOptions.toArray(nativeAdOptionsArray);
            adRequest.setNativeAdOptions(nativeAdOptionsArray);
        }
        return adRequest;
    }


    private final TWMAdViewListener adListener = new TWMAdViewListener() {
        @Override
        public void onReceiveAd(@NonNull TWMAd twmAd) {
            // The callback is trigger when ad load successfully.
            tvResult.setText(getString(R.string.on_receive_ad));

            // Fetch native content with getNativeAdContent function and set UI.
            fetchNativeAdContent();
        }

        @Override
        public void onFailedToReceiveAd(@NonNull TWMAd twmAd, TWMAdRequest.ErrorCode errorCode) {
            // The callback is trigger when ad load fail.
            switch (errorCode) {
            case NO_FILL:
                tvResult.setText(getString(R.string.no_fill));
                break;
            case NETWORK_ERROR:
                tvResult.setText(getString(R.string.network_error));
                break;
            case INTERNAL_ERROR:
                tvResult.setText(getString(R.string.internal_error));
                break;
            case INVALID_REQUEST:
                tvResult.setText(getString(R.string.invalid_request));
                break;
            default:
                break;
            }
        }

        @Override
        public void onPresentScreen(@NonNull TWMAd twmAd) {}

        @Override
        public void onDismissScreen(@NonNull TWMAd twmAd) {}

        @Override
        public void onLeaveApplication(@NonNull TWMAd twmAd) {}
    };

    private void fetchNativeAdContent() {
        TWMNativeAdContent nAd = nativeAd.getNativeAdContent();
        String text;

        // Long Title
        if (nAd.getLongSubject() != null) {
            tvLongTitle.setText(nAd.getLongSubject());
            mNativeAdView.setLongSubjectView(tvLongTitle);
        }
        // Short Title
        if (nAd.getShortSubject() != null ) {
            tvShortTitle.setText(nAd.getShortSubject());
            mNativeAdView.setShortSubjectView(tvShortTitle);
        }
        // Content
        if (nAd.getBody() != null) {
            tvContent.setText(nAd.getBody());
            mNativeAdView.setBodyView(tvContent);
        }

        // Icon - 120x120
        if (nAd.getIconSquare() !=null) {
            ivIcon120x120.setImageDrawable(nAd.getIconSquare().getDrawable());
            ivIcon120x120.setAdjustViewBounds(true);
            mNativeAdView.setSquareIconView(ivIcon120x120);
        }

        // Icon - 96x64
        if (nAd.getIconRect() != null) {
            ivIcon96x64.setImageDrawable(nAd.getIconRect().getDrawable());
            ivIcon96x64.setAdjustViewBounds(true);
            mNativeAdView.setRectangleIconView(ivIcon96x64);
        }

        // CallToAction
        if (nAd.getCallToAction() !=null) {
            tvCTA.setText(nAd.getCallToAction());
            mNativeAdView.setCallToActionView(tvCTA);
        } else {
            text = tvCTA.getText() + " No CTA Text";
            tvCTA.setText(text);
        }

        // Image - 960_640
        if (nAd.getImage960_640() != null) {
            ivImage960x640.setImageDrawable(nAd.getImage960_640().getDrawable());
            ivImage960x640.setAdjustViewBounds(true);
        }

        // Image - 1200_627
        if (nAd.getImage1200_627() != null) {
            ivImage1200x627.setImageDrawable(nAd.getImage1200_627().getDrawable());
            ivImage1200x627.setAdjustViewBounds(true);
        }

        // MediaView
        if (nAd.getMediaContent() != null) {
            // if native ad contains no video
            if (!nAd.getMediaContent().hasVideoContent()) {
                if (mAdMediaPreferImageSizeBig) {
                    nAd.getMediaContent().setMainImageSize(TWMMediaContent.ImageSize.BIG);
                } else {
                    nAd.getMediaContent().setMainImageSize(TWMMediaContent.ImageSize.SMALL);
                }
            }
            mediaView.setMediaContent(nAd.getMediaContent());
        }

        mNativeAdView.setMediaView(mediaView);
        mNativeAdView.setNativeAd(nativeAd);
    }

}
