package com.taiwanmobile.pt.tamedia.tutorial;

import android.content.Intent;
import android.os.Bundle;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;

import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsControllerCompat;

import com.taiwanmobile.pt.tamedia.tutorial.compose.BannerComposeActivity;
import com.taiwanmobile.pt.tamedia.tutorial.compose.InReadComposeActivity;
import com.taiwanmobile.pt.tamedia.tutorial.compose.InterstitialComposeActivity;
import com.taiwanmobile.pt.tamedia.tutorial.compose.NativeAdComposeActivity;

public class MainActivity extends AppCompatActivity {

    private enum AdFormat {
        BANNER_320X50("Banner_320X50"),
        BANNER_300x250("Banner_300x250"),
        BANNER_1200x627("Banner_1200x627"),
        INTERSTITIAL("Interstitial"),
        INREAD_ANCHOR("InRead Anchor"),
        NATIVE_IMAGE("Native Image"),
        NATIVE_VIDEO("Native Video"),
        BANNER_320X50_COMPOSE("Banner_320X50 (Compose)"),
        BANNER_300x250_COMPOSE("Banner_300x250 (Compose)"),
        BANNER_1200x627_COMPOSE("Banner_1200x627 (Compose)"),
        INTERSTITIAL_COMPOSE("Interstitial (Compose)"),
        INREAD_ANCHOR_COMPOSE("InRead Anchor (Compose)"),
        NATIVE_IMAGE_COMPOSE("Native Image (Compose)"),
        NATIVE_VIDEO_COMPOSE("Native Video (Compose)");

        private final String displayName;

        AdFormat(String displayName) {
            this.displayName = displayName;
        }

        @NonNull
        @Override
        public String toString() {
            return displayName;
        }
    }

    private boolean mediaPreferImage = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // make the status bar icons visible (for light status bar backgrounds)
        WindowInsetsControllerCompat insetsController = WindowCompat.getInsetsController(getWindow(), getWindow().getDecorView());
        insetsController.setAppearanceLightStatusBars(true);

        setContentView(R.layout.activity_main);

        String version = BuildConfig.VERSION_NAME;
        int verCode = BuildConfig.VERSION_CODE;
        ActionBar actionBar = getSupportActionBar();
        if (actionBar != null) {
            actionBar.setSubtitle("v" + version + " (" + verCode + ")");
        }

        ListView listView = findViewById(R.id.list_ad);

        ArrayAdapter<AdFormat> adapter;
        adapter = new ArrayAdapter<>(this, android.R.layout.simple_list_item_1, AdFormat.values());
        listView.setAdapter(adapter);
        listView.setOnItemClickListener(adSelectedListener);
    }

    private final AdapterView.OnItemClickListener adSelectedListener = (parent, view, position, id) -> {
        Intent intent = new Intent();
        boolean nativeAdOptions = false;

        AdFormat selectedFormat = (AdFormat) parent.getItemAtPosition(position);

        switch (selectedFormat) {
            case BANNER_320X50:
                intent.putExtra(BannerActivity.KEY_BANNER_TYPE,
                        BannerActivity.TYPE_BANNER_320X50);
                intent.setClass(MainActivity.this, BannerActivity.class);
                break;
            case BANNER_300x250:
                intent.putExtra(BannerActivity.KEY_BANNER_TYPE,
                        BannerActivity.TYPE_BANNER_300x250);
                intent.setClass(MainActivity.this, BannerActivity.class);
                break;
            case BANNER_1200x627:
                intent.putExtra(BannerActivity.KEY_BANNER_TYPE,
                        BannerActivity.TYPE_BANNER_1200x627);
                intent.setClass(MainActivity.this, BannerActivity.class);
                break;
            case INTERSTITIAL:
                intent.setClass(MainActivity.this, InterstitialActivity.class);
                break;
            case INREAD_ANCHOR:
                intent.setClass(MainActivity.this, InReadActivity.class);
                break;
            case NATIVE_IMAGE:
                intent.setClass(MainActivity.this, NativeActivity.class);
                mediaPreferImage = true;
                nativeAdOptions = true;
                break;
            case NATIVE_VIDEO:
                intent.setClass(MainActivity.this, NativeActivity.class);
                nativeAdOptions = true;
                break;
            case BANNER_320X50_COMPOSE:
                intent.putExtra(BannerComposeActivity.KEY_BANNER_TYPE, BannerActivity.TYPE_BANNER_320X50);
                intent.setClass(MainActivity.this, BannerComposeActivity.class);
                break;
            case BANNER_300x250_COMPOSE:
                intent.putExtra(BannerComposeActivity.KEY_BANNER_TYPE, BannerActivity.TYPE_BANNER_300x250);
                intent.setClass(MainActivity.this, BannerComposeActivity.class);
                break;
            case BANNER_1200x627_COMPOSE:
                intent.putExtra(BannerComposeActivity.KEY_BANNER_TYPE, BannerActivity.TYPE_BANNER_1200x627);
                intent.setClass(MainActivity.this, BannerComposeActivity.class);
                break;
            case INREAD_ANCHOR_COMPOSE:
                intent.setClass(MainActivity.this, InReadComposeActivity.class);
                break;
            case INTERSTITIAL_COMPOSE:
                intent.setClass(MainActivity.this, InterstitialComposeActivity.class);
                break;
            case NATIVE_IMAGE_COMPOSE:
                intent.setClass(MainActivity.this, NativeAdComposeActivity.class);
                intent.putExtra(NativeAdComposeActivity.KEY_PREFER_IMAGE, true);
                break;
            case NATIVE_VIDEO_COMPOSE:
                intent.setClass(MainActivity.this, NativeAdComposeActivity.class);
                intent.putExtra(NativeAdComposeActivity.KEY_PREFER_IMAGE, false);
                break;
            default:
                intent.setClass(MainActivity.this, BannerActivity.class);
                break;
        }

        if(nativeAdOptions) {
            boolean disableImageLoading = false;
            boolean videoCustomControl = false;
            boolean startUnmuted = false;
            intent.putExtra(NativeActivity.KEY_AD_DISABLE_IMAGE_LOADING, disableImageLoading);
            intent.putExtra(NativeActivity.KEY_AD_VIDEO_START_UNMUTED, startUnmuted);
            intent.putExtra(NativeActivity.KEY_AD_VIDEO_CUSTOM_CONTROLS_REQUESTED, videoCustomControl);
            intent.putExtra(NativeActivity.KEY_AD_MEDIA_PREFER_IMAGE, mediaPreferImage);
        }

        startActivity(intent);
    };
}
