package com.taiwanmobile.pt.tamedia.tutorial;

import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsControllerCompat;

import com.taiwanmobile.pt.adp.view.TWMAd;
import com.taiwanmobile.pt.adp.view.TWMAdRequest;
import com.taiwanmobile.pt.adp.view.TWMAdViewListener;
import com.taiwanmobile.pt.adp.view.TWMInterstitialAd;

public class InterstitialActivity extends AppCompatActivity {
    
    private TextView tvResult = null;
    private TWMInterstitialAd interstitialAd = null;
    public final String TAMEDIA_INTERSTITIAL_ADUNITID = "YOUR_INTERSTITIAL_AD_UNIT_ID";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // make the status bar icons visible (for light status bar backgrounds)
        WindowInsetsControllerCompat insetsController = WindowCompat.getInsetsController(getWindow(), getWindow().getDecorView());
        insetsController.setAppearanceLightStatusBars(true);

        setContentView(R.layout.activity_interstitial);
        tvResult = findViewById(R.id.interstitial_result);

        initAd();
    }

    public void initAd() {
        // Init interstitial with ad unit id.
        interstitialAd = new TWMInterstitialAd(InterstitialActivity.this,
                TAMEDIA_INTERSTITIAL_ADUNITID);
        // Set listener for interstitial.
        interstitialAd.setAdListener(adListener);
        // Request interstitial from TAMedia.
        interstitialAd.loadAd(new TWMAdRequest());
    }

    private final TWMAdViewListener adListener = new TWMAdViewListener() {
        @Override
        public void onReceiveAd(@NonNull TWMAd twmAd) {
            // The callback is trigger when ad load successfully.
            tvResult.setText(getString(R.string.on_receive_ad));

            // call show() after interstitial load finish.
            interstitialAd.show();
        }

        @Override
        public void onFailedToReceiveAd(@NonNull TWMAd twmAd,
                                        TWMAdRequest.ErrorCode errorCode) {
            // The callback is trigger when ad load fail.
            switch (errorCode) {
            case NO_FILL:
                tvResult.setText(getString(R.string.no_fill));
                break;
            case NETWORK_ERROR:
                tvResult.setText(getString(R.string.network_error));
                break;
            case INTERNAL_ERROR:
                tvResult.setText(getString(R.string.internal_error));
                break;
            case INVALID_REQUEST:
                tvResult.setText(getString(R.string.invalid_request));
                break;
            default:
                break;
            }
        }

        @Override
        public void onPresentScreen(@NonNull TWMAd twmAd) {
            // The callback is triggered when ad is shown.
        }

        @Override
        public void onDismissScreen(@NonNull TWMAd twmAd) {
            // The callback is triggered when user has closed ad.
        }

        @Override
        public void onLeaveApplication(@NonNull TWMAd twmAd) {
            // The callback would be trigeer when user has left the app.
        }
    };

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (interstitialAd != null) {
            interstitialAd.destroy();
        }
    }
}
