package com.taiwanmobile.pt.tamedia.tutorial;

import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsControllerCompat;

import com.taiwanmobile.pt.adp.view.TWMAd;
import com.taiwanmobile.pt.adp.view.TWMAdRequest;
import com.taiwanmobile.pt.adp.view.TWMAdViewListener;
import com.taiwanmobile.pt.adp.view.inread.TWMInReadAdAnchor;

public class InReadActivity extends AppCompatActivity {

    public final String TAMEDIA_INREAD_ANCHOR_ADUNITID = "YOUR_INREAD_AD_UNIT_ID";

    private TextView tvResult = null;
    private TWMInReadAdAnchor anchorView = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // make the status bar icons visible (for light status bar backgrounds)
        WindowInsetsControllerCompat insetsController = WindowCompat.getInsetsController(getWindow(), getWindow().getDecorView());
        insetsController.setAppearanceLightStatusBars(true);

        setContentView(R.layout.activity_inread);
        tvResult = findViewById(R.id.inread_result);

        initAd();
    }

    @Override
    protected void onResume() {
        super.onResume();

        if (anchorView != null) {
            anchorView.resume();
        }
    }

    @Override
    protected void onPause() {
        if (anchorView != null) {
            anchorView.pause();
        }

        super.onPause();
    }

    @Override
    protected void onDestroy() {

        if (anchorView != null) {
            anchorView.destroy();
        }

        super.onDestroy();
    }

    public void initAd() {
        anchorView = new TWMInReadAdAnchor(InReadActivity.this,
            TAMEDIA_INREAD_ANCHOR_ADUNITID);
        // Set listener for inread.
        anchorView.setAdListener(adListener);
        // Request inread from TAMedia.
        anchorView.loadAd(new TWMAdRequest());
    }

    private final TWMAdViewListener adListener = new TWMAdViewListener() {
        @Override
        public void onReceiveAd(@NonNull TWMAd twmAd) {
            // The callback is trigger when ad load successfully.
            tvResult.setText(getString(R.string.on_receive_ad));

        }

        @Override
        public void onFailedToReceiveAd(@NonNull TWMAd twmAd, TWMAdRequest.ErrorCode errorCode) {
            // The callback is trigger when ad load fail.
            switch (errorCode) {
            case NO_FILL:
                tvResult.setText(getString(R.string.no_fill));
                break;
            case NETWORK_ERROR:
                tvResult.setText(getString(R.string.network_error));
                break;
            case INTERNAL_ERROR:
                tvResult.setText(getString(R.string.internal_error));
                break;
            case INVALID_REQUEST:
                tvResult.setText(getString(R.string.invalid_request));
                break;
            default:
                break;
            }
        }

        @Override
        public void onPresentScreen(@NonNull TWMAd twmAd) {
            // The callback is triggered when user has clicked ad.
        }

        @Override
        public void onDismissScreen(@NonNull TWMAd twmAd) {
            // The callback is triggered when user has returned to the app after
            // clicking ad.
        }

        @Override
        public void onLeaveApplication(@NonNull TWMAd twmAd) {
            // The callback would be trigeer when user has left the app.
        }
    };
}
