package com.taiwanmobile.pt.tamedia.tutorial;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsControllerCompat;

import com.taiwanmobile.pt.adp.view.TWMAd;
import com.taiwanmobile.pt.adp.view.TWMAdRequest;
import com.taiwanmobile.pt.adp.view.TWMAdSize;
import com.taiwanmobile.pt.adp.view.TWMAdView;
import com.taiwanmobile.pt.adp.view.TWMAdViewListener;

public class BannerActivity extends AppCompatActivity {

    private RelativeLayout root = null;
    private TextView tvResult = null;
    private TWMAdView adView = null;

    public final static String KEY_BANNER_TYPE = "BANNER_TYPE";
    public final static int TYPE_BANNER_320X50 = 0;
    public final static int TYPE_BANNER_300x250 = 1;
    public final static int TYPE_BANNER_1200x627 = 2;

    public final String TAMEDIA_BANNER_320X50 = "YOUR_BANNER_AD_UNIT_ID";
    public final String TAMEDIA_BANNER_300x250 = "YOUR_BANNER_AD_UNIT_ID";
    public final String TAMEDIA_BANNER_1200x627 = "YOUR_BANNER_AD_UNIT_ID";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // make the status bar icons visible (for light status bar backgrounds)
        WindowInsetsControllerCompat insetsController = WindowCompat.getInsetsController(getWindow(), getWindow().getDecorView());
        insetsController.setAppearanceLightStatusBars(true);

        setContentView(R.layout.activity_banner);
        root = findViewById(R.id.banner_container);
        tvResult = findViewById(R.id.banner_result);

        // get extra data from MainActivity
        Intent intent = getIntent();
        Bundle args = intent.getExtras();
        int bannerType = args.getInt(KEY_BANNER_TYPE);

        initAd(bannerType);
    }

    @Override
    protected void onPause() {
        if (adView != null) {
            adView.stopLoading();
        }
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        if (adView != null) {
            adView.destroy();
        }
        super.onDestroy();
    }

    public void initAd(int bannerType) {
        // Init banner with ad size and ad unit id.
        switch(bannerType){
            case 1:
                adView = new TWMAdView(BannerActivity.this, TWMAdSize.BANNER_300X250,
                        TAMEDIA_BANNER_300x250);
                break;
            case 2:
                adView = new TWMAdView(BannerActivity.this, TWMAdSize.BANNER_1200X627,
                        TAMEDIA_BANNER_1200x627);
                break;
            case 0:
            default:
                adView = new TWMAdView(BannerActivity.this, TWMAdSize.BANNER,
                        TAMEDIA_BANNER_320X50);
                break;
        }

        // Set listener for banner.
        adView.setAdListener(adListener);

        // Set banner position within container.
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(
                RelativeLayout.LayoutParams.WRAP_CONTENT,
                RelativeLayout.LayoutParams.WRAP_CONTENT);
        layoutParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        layoutParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
        adView.setLayoutParams(layoutParams);

        // Add banner into container.
        root.addView(adView);

        // Request banner from TAMedia.
        adView.loadAd(new TWMAdRequest());
    }

    private final TWMAdViewListener adListener = new TWMAdViewListener() {
        @Override
        public void onReceiveAd(@NonNull TWMAd twmAd) {
            // The callback is trigger when ad load successfully.
            tvResult.setText(getString(R.string.on_receive_ad));
        }

        @Override
        public void onFailedToReceiveAd(@NonNull TWMAd twmAd, TWMAdRequest.ErrorCode errorCode) {
            // The callback is trigger when ad load fail.
            switch (errorCode) {
            case NO_FILL:
                tvResult.setText(getString(R.string.no_fill));
                break;
            case NETWORK_ERROR:
                tvResult.setText(getString(R.string.network_error));
                break;
            case INTERNAL_ERROR:
                tvResult.setText(getString(R.string.internal_error));
                break;
            case INVALID_REQUEST:
                tvResult.setText(getString(R.string.invalid_request));
                break;
            default:
                break;
            }
        }

        @Override
        public void onPresentScreen(@NonNull TWMAd twmAd) {
            // The callback is trigger when ad is present on screen.
        }

        @Override
        public void onDismissScreen(@NonNull TWMAd twmAd) {
            // The callback is trigger when ad is dismiss on screen.
        }

        @Override
        public void onLeaveApplication(@NonNull TWMAd twmAd) {
            // The callback would be trigeer when user has left the app.
        }
    };
}
